/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.up = function (knex) {
    return knex.schema.createTable("users", (table) => {
        table.increments('id');
        table.string('username', 255).notNullable();
        table.string('password', 255).notNullable();
        table.string('email', 255).notNullable();
    })
};

/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.down = function (knex) {
    return knex.schema.dropTable('users')
};
