/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.up = function (knex) {
    return knex.schema.createTable("posts", (table) => {
        table.increments('id');
        table.text('image').notNullable();
        table.text('like').notNullable();
        table.text('description').notNullable();
        table.bigInteger('users_id').unsigned();
    })
};

/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.down = function (knex) {
    return knex.schema.dropTable('posts')
};
