/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.up = function (knex) {
    return knex.schema.createTable("users_friends", (table) => {
        table.increments('id');
        table.bigInteger('user_id').unsigned();
        table.bigInteger('friend_id').unsigned();
        table.timestamps(true, true)
    })
};

/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
module.exports.down = function (knex) {
    return knex.schema.dropTable('users_friends')
};
