const express = require("express")
const database = require("./database/index.js")
const cors = require("cors")
const jwt = require('jsonwebtoken');

const app = express()
const SECRET_KEY = 'your_secret_key';

app.use(cors())
app.use(express.json({
    limit: '200mb'
}))
const authenticateToken = (req, res, next) => {
    const authHeader = req.headers['authorization'];
    const token = authHeader && authHeader.split(' ')[1]; // Bearer token şeklinde gelir

    if (!token) return res.sendStatus(401); // Token yoksa yetkisiz erişim

    jwt.verify(token, SECRET_KEY, (err, user) => {
        if (err) return res.sendStatus(403); // Token geçersizse erişim yasak
        req.user = user;
        next(); // Token geçerliyse bir sonraki middleware'e geç
    });
};
app.get('/', async (req, res) => {
    const result = await database("users")
    res.json({
        message: "Users Fetched !",
        data: result
    })
});
app.post('/login', async (req, res) => {
    console.log(req.body)
    const result = await database("users").where('username', req.body.username).andWhere('password', req.body.password)
    if (result.length != 0) {
        const user = result[0];
        const token = jwt.sign({ id: user.id, username: user.username }, SECRET_KEY, { expiresIn: '1h' });
        res.json({
            message: "User Logged !",
            token: token,
            login: true
        })
    } else {
        res.json({
            message: "Login Failed !",
            login: false
        })
    }
});

app.post('/register', async (req, res) => {
    console.log(req.body)
    const existUser = await database("users").where({ username: req.body.username });
    if (existUser.length > 0) return res.json({
        message: "Username Exists !",
        success: false
    })
    const result = await database("users").insert({ username: req.body.username, email: req.body.email, password: req.body.password, profile_photo: "https://w7.pngwing.com/pngs/340/946/png-transparent-avatar-user-computer-icons-software-developer-avatar-child-face-heroes-thumbnail.png" })
    res.json({
        message: "Register Success !",
        success: true
    })
});

app.use(authenticateToken)
app.get("/posts", async (req, res) => {
    const result = await database('posts')
        .join('users', 'posts.users_id', 'users.id')
        .select('posts.*', "users.username", "users.profile_photo")
        .select(database.raw('(SELECT COUNT(*) FROM posts_likes WHERE posts_id = posts.id) as post_like'))
        .select(database.raw(`(select count(*) from posts_likes where posts_id = posts.id and users_id = ${req.user.id}) as user_liked`))
        .whereRaw(`users_id in (select friend_id from users_friends where user_id = ${req.user.id}) or users_id = ${req.user.id}`)
        .orderBy('posts.created_at', "desc")
    res.json({
        message: "Users Fetched !",
        data: result
    })
})

app.delete("/posts/:id", async (req, res) => {
    const deletePost = await database('posts').where("id", req.params.id);
    if (deletePost[0].users_id != req.user.id) return res.status(403).json({
        message: "Forbidden !",
        success: false
    })
    await database('posts').where("id", req.params.id).del();
    res.json({
        message: "Users Fetched !",
        success: true
    })
})

app.get("/followers/:username", async (req, res) => {
    let username = req.params.username
    if (req.params.username == 'me') {
        username = req.user.username
    }
    const users = await database('users')
        .where('username', username);
    const followers = await database('users_friends').join('users', 'users_friends.user_id', 'users.id')
        .select(
            'users.id',
            'users.username',
            'users.profile_photo',
            database.raw(
                '(SELECT COUNT(*) FROM users_friends WHERE user_id = ? AND friend_id = users.id) as following',
                [req.user.id]
            )
        )
        .where("users_friends.friend_id", users[0].id)
    return res.json({ message: "TEST", data: followers })
})

app.get("/follow/:username", async (req, res) => {
    let username = req.params.username
    if (req.params.username == 'me') {
        username = req.user.username
    }
    const users = await database('users')
        .where('username', username);
    const follow = await database('users_friends').join('users', 'users_friends.friend_id', 'users.id')
        .select('users.id', 'users.username', 'users.profile_photo', database.raw(
            '(SELECT COUNT(*) FROM users_friends WHERE user_id = ? AND friend_id = users.id) as following',
            [req.user.id]
        ))
        .where("users_friends.user_id", users[0].id)
    return res.json({ message: "TEST", data: follow })
})

app.get("/user/:username", async (req, res) => {
    let username = req.params.username
    if (req.params.username == 'me') {
        username = req.user.username
    }
    const user = await database('users')
        .where('username', username);
    return res.json({ message: "TEST", data: user })
})

app.get("/new-friends", async (req, res) => {
    const newFriends = await database('users')
        .where('users.id', '!=', req.user.id)
        .whereNotIn('users.id', function () {
            this.select('friend_id')
                .from('users_friends')
                .where('user_id', req.user.id);
        })
    return res.json({ message: "TEST", data: newFriends })
})

app.get("/posts/:username", async (req, res) => {
    const posts = await database('posts as p')
        .join('users as u', 'p.users_id', 'u.id')
        .select('p.*')
        .where('u.username', req.params.username);
    return res.json({ message: "TEST", data: posts })
})

app.get("/follow-user/:username", async (req, res) => {

    const users = await database('users')
        .where('username', req.params.username);

    await database('users_friends').insert({
        user_id: req.user.id,
        friend_id: users[0].id
    })
    return res.json({ message: "başarılı", success: true })
})

app.get("/like-post/:id", async (req, res) => {
    let isLike = false
    const like = await database('posts_likes')
        .where('users_id', req.user.id).andWhere('posts_id', req.params.id)
    if (!like.length) {
        await database('posts_likes').insert({
            users_id: req.user.id,
            posts_id: req.params.id
        })
        isLike = true
    } else {
        await database('posts_likes').where("id", like[0].id).del();
    }
    return res.json({ message: "başarılı", success: true, isLike: isLike })
})

app.get("/unfollow-user/:username", async (req, res) => {

    const users = await database('users')
        .where('username', req.params.username);

    await database('users_friends').where({
        user_id: req.user.id,
        friend_id: users[0].id
    }).del()
    return res.json({ message: "başarılı", success: true })
})

app.post("/posts", async (req, res) => {
    await database('posts').insert({
        users_id: req.user.id,
        image: req.body.image,
        description: req.body.description,
        like: 0
    });
    return res.json({ message: "başarılı", success: true });
})

app.get("/profile/:username", async (req, res) => {
    let username = req.params.username
    if (req.params.username == 'me') {
        username = req.user.username
    }
    const user = await database('users')
        .where('username', username);
    const userposts = await database('posts')
        .select("*")
        .select(database.raw(`(select count(*) from posts_likes where posts_id = posts.id and users_id = ${req.user.id}) as user_liked`))
        .select(database.raw('(SELECT COUNT(*) FROM posts_likes WHERE posts_id = posts.id) as post_like'))
        .where('users_id', "=", user[0]?.id)
        .orderBy('posts.created_at', "desc")
    const followersCount = await database('users_friends')
        .where('friend_id', user[0]?.id)
        .count('* as user_count')
    const followingCount = await database('users_friends')
        .where('user_id', user[0]?.id)
        .count('* as user_count')
    const isFollowing = await database('users_friends').where({
        user_id: req.user.id,
        friend_id: user[0].id
    })
    const isMe = (req.user.username == username)
    return res.json({ message: "TEST", data: user, userposts: userposts, followersCount: followersCount[0].user_count, followingCount: followingCount[0].user_count, isFollowing: (isFollowing.length > 0), isMe: isMe })
})
app.listen(8080, () => { console.log(8080, "çalışıyor") })